VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAliases"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Pretty much same thing as clsFilters with a few modifications
'since I didn't want to rewrite the same thing :]
Private Aliases() As Alias
Private Type Alias
    Alias   As String
    Command As String
End Type

Public Function getAlias(ByRef Alias As String) As Boolean
    Dim i As Integer
    For i = 0 To UBound(Aliases) - 1
        If StrComp(Aliases(i).Alias, Alias, vbTextCompare) = 0 Then
            'Match was found:
            getAlias = True
            Exit Function
        End If
    Next i
End Function

Public Function addAlias(ByRef Alias As String, ByRef Command As String) As Boolean
    If (indexAlias(Alias) = -1) Then
        'Set values
        With Aliases(UBound(Aliases))
            .Alias = Alias
            .Command = Command
        End With
        'Increase the upper bound and preserve the array
        ReDim Preserve Aliases(UBound(Aliases) + 1)
        'Set function equal to True
        addAlias = True
    End If
End Function

Public Function removeAlias(ByRef Alias As String) As Boolean
    'First find the index
    Dim AliasIndex As Integer
    Dim i          As Integer
    If (UBound(Aliases) = 0) Then Exit Function
    AliasIndex = indexAlias(Alias)
    'Found the alias, remove it now. Validate index so we do not get any subscript errors.
    If (AliasIndex <> -1 And AliasIndex < UBound(Aliases)) Then
        For i = AliasIndex To UBound(Aliases) - 1
            'Set each previous array to the one above it.
            Aliases(i) = Aliases(i + 1)
        Next i
        'Preserve array
        ReDim Preserve Aliases(UBound(Aliases) - 1)
        removeAlias = True
    End If
End Function

Public Function indexAlias(ByRef Alias As String) As Integer
    Dim i As Integer
    For i = 0 To UBound(Aliases) - 1
        'Test if the alias matches _exactly_ (non-case sensitive) AND the same type.
        If (StrComp(Aliases(i).Alias, Alias, vbTextCompare) = 0) Then
            'Match was found:
            indexAlias = i
            Exit Function
        End If
    Next i
    'Not found, handle odd index
    indexAlias = -1
End Function

Public Function getAliasArray() As String()
    Dim i As Integer
    Dim AliasArray() As String
    ReDim AliasArray(0)
    For i = 0 To UBound(Aliases) - 1
        AliasArray(UBound(AliasArray)) = Aliases(i).Alias & Space(1) & Aliases(i).Command
        ReDim Preserve AliasArray(UBound(AliasArray) + 1)
    Next i
    getAliasArray = AliasArray
End Function

Public Function getAliasInfo(ByRef AliasIndex As Integer) As String
    getAliasInfo = Aliases(AliasIndex).Alias & Space(1) & Aliases(AliasIndex).Command
End Function

Public Function resetAliases()
    ReDim Aliases(0)
End Function

Public Function countAliases() As Integer
    countAliases = UBound(Aliases)
End Function

Private Sub Class_Initialize()
    ReDim Aliases(0)
End Sub

Private Sub Class_Terminate()
    ReDim Aliases(0)
End Sub

